import { useTheme } from '@mui/material'
import React from 'react'

const GooglePlay = () => {
    const theme = useTheme()
    const isSmall = theme.breakpoints.down('md')
    return (
        <svg
            width={isSmall ? '24' : '32'}
            height={isSmall ? '24' : '32'}
            viewBox="0 0 32 32"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <g clipPath="url(#clip0_2987_1319)">
                <path
                    d="M23.3925 11.319C19.8097 9.30815 14.0593 6.07921 5.14002 1.06774C4.53868 0.669221 3.84681 0.616996 3.24902 0.820032L18.5521 16.1762L23.3925 11.319Z"
                    fill="#32BBFF"
                />
                <path
                    d="M3.24887 0.820312C3.13683 0.858393 3.0278 0.904332 2.92353 0.959821C2.2634 1.31814 1.77832 2.00764 1.77832 2.87969V29.4733C1.77832 30.3453 2.26334 31.0348 2.92353 31.3931C3.02762 31.4485 3.13659 31.4946 3.24851 31.5329L18.5519 16.1765L3.24887 0.820312Z"
                    fill="#32BBFF"
                />
                <path
                    d="M18.5519 16.1763L3.24854 31.5327C3.8465 31.7373 4.53837 31.6891 5.13989 31.2847C13.7897 26.4243 19.4753 23.2336 23.0995 21.2057C23.2004 21.1488 23.2992 21.0932 23.3969 21.0381L18.5519 16.1763Z"
                    fill="#32BBFF"
                />
                <path
                    d="M1.77832 16.1763V29.4731C1.77832 30.3451 2.26334 31.0346 2.92353 31.3929C3.02762 31.4483 3.13659 31.4944 3.24851 31.5328L18.5519 16.1763H1.77832Z"
                    fill="#2C9FD9"
                />
                <path
                    d="M5.13967 1.06748C4.42557 0.594318 3.58347 0.607797 2.92334 0.959348L18.3194 16.409L23.3921 11.3187C19.8094 9.30789 14.059 6.07896 5.13967 1.06748Z"
                    fill="#29CC5E"
                />
                <path
                    d="M18.3196 15.9434L2.92334 31.3929C3.58353 31.7444 4.42557 31.7647 5.13967 31.2848C13.7895 26.4244 19.4751 23.2337 23.0992 21.2057C23.2001 21.1489 23.299 21.0933 23.3967 21.0382L18.3196 15.9434Z"
                    fill="#D93F21"
                />
                <path
                    d="M29.7821 16.1758C29.7821 15.4389 29.4116 14.6953 28.6772 14.283C28.6772 14.283 27.3039 13.5141 23.0944 11.1514L18.0874 16.1758L23.0993 21.2051C27.2626 18.8594 28.6772 18.0685 28.6772 18.0685C29.4116 17.6562 29.7821 16.9126 29.7821 16.1758Z"
                    fill="#FFD500"
                />
                <path
                    d="M28.6772 18.0691C29.4116 17.6567 29.7821 16.9131 29.7821 16.1763H18.0874L23.0993 21.2057C27.2627 18.86 28.6772 18.0691 28.6772 18.0691Z"
                    fill="#FFAA00"
                />
            </g>
            <defs>
                <clipPath id="clip0_2987_1319">
                    <rect
                        width="30.8409"
                        height="30.948"
                        fill="white"
                        transform="translate(0.359863 0.703125)"
                    />
                </clipPath>
            </defs>
        </svg>
    )
}

export default GooglePlay
